//=============================================================================
// BattleQuickeningSwitch.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/01/10 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 戦闘加速スイッチ
 * @target MZ
 * @author くろあめ
 *
 * @param BattleQuickeningSwitch
 * @text 戦闘加速スイッチ
 * @desc このスイッチがONの時、戦闘アニメの再生終了を待たずにダメージ表示を行い、戦闘を加速します。
 * @default 4
 * @type number
 *
 * @param AnimationBaseDelay
 * @text アニメ再生時ウェイトフレーム
 * @desc アニメ再生時に確保する、基本ウェイトフレームを設定します。
 * @default 4
 * @type number
 *
 * @param AnimationNextDelay
 * @text アニメ連続再生時ウェイトフレーム
 * @desc アニメ連続再生時に確保する、ウェイトフレームを設定します。
 * @default 4
 * @type number
 *
 * @param BattleQuickeningKey
 * @text 戦闘加速キー
 * @desc このキーが押されている間、戦闘が加速します。「noFast」指定で、機能を無効化します。
 * @type select
 * @option shift
 * @value shift
 * @option control
 * @value control
 * @option pageup
 * @value pageup
 * @option pagedown
 * @value pagedown
 * @option tab
 * @value tab
 * @option noskip
 * @value noskip
 * @default shift
 *
 * @help
 * 特定のスイッチがONの時、もしくはSHIFTキー押しっぱなしの時
 * 戦闘アニメの再生終了を待たずにダメージ表示を行い、戦闘を加速します
 * 関数を再定義するので、できるだけ上の配置を推奨します
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

    Spriteset_Base.prototype.animationBaseDelay = function() {
        return param.AnimationBaseDelay;
    };

    Spriteset_Base.prototype.animationNextDelay = function() {
        return param.AnimationNextDelay;
    };
    
    Spriteset_Battle.prototype.isBusy = function() {
        if($gameSwitches.value(param['BattleQuickeningSwitch']) || Input.isPressed(param['BattleQuickeningKey'])){
            return this.isAnyoneMoving();
        }
        else{
            return this.isAnimationPlaying() || this.isAnyoneMoving();
        }
    };
})();